/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.network.message;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.lyric.LyricParser;
import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.client.audio.NetMusicSound;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MusicToClientMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<MusicToClientMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"music_to_client"));
    public static final StreamCodec<ByteBuf, MusicToClientMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, MusicToClientMessage::getPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, MusicToClientMessage::getUrl, (StreamCodec)ByteBufCodecs.VAR_INT, MusicToClientMessage::getTimeSecond, (StreamCodec)ByteBufCodecs.STRING_UTF8, MusicToClientMessage::getSongName, MusicToClientMessage::new);
    private static final Pattern PATTERN = Pattern.compile("^.*?\\?id=(\\d+)\\.mp3$");
    private final BlockPos pos;
    private final String url;
    private final int timeSecond;
    private final String songName;

    public MusicToClientMessage(BlockPos pos, String url, int timeSecond, String songName) {
        this.pos = pos;
        this.url = url;
        this.timeSecond = timeSecond;
        this.songName = songName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getUrl() {
        return this.url;
    }

    public int getTimeSecond() {
        return this.timeSecond;
    }

    public String getSongName() {
        return this.songName;
    }

    public static void handle(MusicToClientMessage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> MusicToClientMessage.onHandle(message), Util.backgroundExecutor()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(MusicToClientMessage message) {
        Matcher matcher;
        LyricRecord[] record = new LyricRecord[1];
        if (((Boolean)GeneralConfig.ENABLE_PLAYER_LYRICS.get()).booleanValue() && message.url.startsWith("https://music.163.com/") && (matcher = PATTERN.matcher(message.url)).find()) {
            long musicId = Long.parseLong(matcher.group(1));
            try {
                String lyric = NetMusic.NET_EASE_WEB_API.lyric(musicId);
                record[0] = LyricParser.parseLyric(lyric, message.songName);
            }
            catch (IOException e) {
                NetMusic.LOGGER.error((Object)e);
            }
        }
        MusicPlayManager.play(message.url, message.songName, url -> new NetMusicSound(message.pos, (URL)url, message.timeSecond, record[0]));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

